jQuery(function($){
  // Handle Email Selected button
  $('#dfs_email_selected').on('click', function(e){
    e.preventDefault();
    reloadTemplates();
    $('#dfs-email-modal').show();
  });

  // Reload template list
  function reloadTemplates(){
    $.post(DFS_Email.ajax_url, {
      action: 'dfs_get_templates',
      _ajax_nonce: DFS_Email.nonce
    }, function(res){
      if(res.success){
        var sel = $('#dfs-template-select').empty().append('<option value="">-- Select Template --</option>');
        $.each(res.data, function(k,v){
          sel.append('<option value="'+k+'">'+k+'</option>');
        });
      }
    });
  }

  // On template select change
  $('#dfs-template-select').on('change', function(){
    var tpl = $(this).val();
    if(!tpl){
      $('#dfs-email-subject').val('');
      $('#dfs-email-body').val('');
      return;
    }
    $.post(DFS_Email.ajax_url, {
      action: 'dfs_get_templates',
      _ajax_nonce: DFS_Email.nonce
    }, function(res){
      if(res.success && res.data[tpl]){
        $('#dfs-email-subject').val(res.data[tpl].subject);
        $('#dfs-email-body').val(res.data[tpl].body);
        // Populate TinyMCE editor
        if (typeof tinymce !== 'undefined') {
            var ed = tinymce.get('dfs-email-body');
            if (ed) { ed.setContent(res.data[tpl].body); ed.save(); }
        }
      }
    });
  });

  // Save Template handler
  $('#dfs-save-template').on('click', function(e){
    e.preventDefault();
    if (typeof tinymce !== 'undefined') tinymce.triggerSave();
    var name = prompt('Enter template name:');
    if(!name) return;
    $.post(DFS_Email.ajax_url, {
      action: 'dfs_save_template',
      name: name,
      subject: $('#dfs-email-subject').val(),
      body: (typeof tinymce !== 'undefined' && tinymce.get('dfs-email-body') ? tinymce.get('dfs-email-body').getContent() : $('#dfs-email-body').val()),
      _ajax_nonce: DFS_Email.nonce
    }, function(res){
      if(res.success){
        alert('Template saved.');
        reloadTemplates();
      }
    });
  });

  // Delete Template handler
  $('#dfs-delete-template').on('click', function(e){
    e.preventDefault();
    var tpl = $('#dfs-template-select').val();
    if(!tpl){
      alert('Select a template to delete.');
      return;
    }
    if(!confirm('Delete template "'+tpl+'"?')) return;
    $.post(DFS_Email.ajax_url, {
      action: 'dfs_delete_template',
      name: tpl,
      _ajax_nonce: DFS_Email.nonce
    }, function(res){
      if(res.success){
        alert('Template deleted.');
        $('#dfs-email-subject,#dfs-email-body').val('');
        reloadTemplates();
      }
    });
  });
  
  // Edit Template handler
  $('#dfs-edit-template').on('click', function(e){
    e.preventDefault();
    if (typeof tinymce !== 'undefined') tinymce.triggerSave();
    var tpl = $('#dfs-template-select').val();
    if (!tpl) {
      alert('Select a template to edit.');
      return;
    }
    var subject = $('#dfs-email-subject').val();
    var body = (typeof tinymce !== 'undefined' && tinymce.get('dfs-email-body') ? tinymce.get('dfs-email-body').getContent() : $('#dfs-email-body').val());
    $.post(DFS_Email.ajax_url, {
      action:   'dfs_save_template',   // reuse save endpoint to overwrite
      name:     tpl,
      subject:  subject,
      body:     body,
      _ajax_nonce: DFS_Email.nonce
    }, function(res){
      if (res.success) {
        alert('Template updated.');
        reloadTemplates();
      } else {
        alert('Update failed.');
      }
    });
  });

  // Send emails
  $('#dfs-send-emails').on('click', function(e){
    e.preventDefault();
    $('#dfs-email-modal').hide();
    $('#dfs-email-progress').show();
    $('#dfs-progress-list').empty();
    var ids = $('.dfs_check_row:checked').map(function(){ return $(this).val(); }).get();
    // Queue items
    $.each(ids, function(i,id){
      var row = $('.dfs_check_row[value="'+id+'"]').closest('tr');
      var name = row.find('td:eq(2)').text();
      var email = row.find('td:eq(9)').text();
      $('#dfs-progress-list').append('<li data-id="'+id+'">Queued: '+name+' ('+email+')</li>');
    });
    // Process sequentially
    var promise = $.Deferred().resolve();
    $.each(ids, function(i,id){
      promise = promise.then(function(){
        var row = $('.dfs_check_row[value="'+id+'"]').closest('tr');
        var name = row.find('td:eq(2)').text();
        var email = row.find('td:eq(9)').text();
        $('#dfs-progress-list li[data-id="'+id+'"]').text('Sending: '+name+' ('+email+')');
        return $.post(DFS_Email.ajax_url, {
          action: 'dfs_send_email',
          id: id,
          subject: $('#dfs-email-subject').val(),
          body: (typeof tinymce !== 'undefined' && tinymce.get('dfs-email-body') ? tinymce.get('dfs-email-body').getContent() : $('#dfs-email-body').val()),
          _ajax_nonce: DFS_Email.nonce
        });
      }).then(function(res){
        var row = $('.dfs_check_row[value="'+id+'"]').closest('tr');
        var name = row.find('td:eq(2)').text();
        var email = row.find('td:eq(9)').text();
        var msg = (res.success ? 'Sent: ' : 'Failed: ') + name + ' ('+email+')' + (res.success ? '' : (': '+res.data));
        $('#dfs-progress-list li[data-id="'+id+'"]').text(msg);
      });
    });
  });

  // Close buttons
  $('#dfs-email-close').on('click', function(){ $('#dfs-email-modal').hide(); });
  $('#dfs-progress-close').on('click', function(){ $('#dfs-email-progress').hide(); });
});